package gov.va.med.mhv.common.essapi.interceptor;

import gov.va.med.mhv.common.essapi.cache.CacheHandler;
import gov.va.med.mhv.common.api.transfer.ErrorTO;
//import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.common.api.dto.PatientDTO;
//import gov.va.med.mhv.usermgmt.util.Auditor;



import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

/**
 * 
 * RECEIVE (PRE/USER/POST)_STREAM READ (PRE/USER/POST)_PROTOCOL UNMARSHAL
 * (PRE/USER/POST)_LOGICAL PRE_INVOKE INVOKE POST_INVOKE
 */
public class ResponseInterceptor extends AbstractPhaseInterceptor<Message> {
	private Log log = LogFactory.getLog(ResponseInterceptor.class);
	
	public ResponseInterceptor() {
		super(Phase.SEND_ENDING);
	}

	public void handleMessage(Message outboundMessage) {
		if( log.isInfoEnabled()) {
			log.info("[Thread " + Thread.currentThread().getId() + "] ResponseInterceptor ");
		}
		
		Message inboundMessage = CacheHandler.getInstance().getInboundMessage();
		ErrorTO error = CacheHandler.getInstance().getError();
		
		if( log.isInfoEnabled()) {
			log.info((error == null ? "SUCCESS" : "ERROR") + ": "
				+ CacheHandler.getInstance().getSession()
				+ "; Request: "
				+ String.valueOf(inboundMessage.get(Message.HTTP_REQUEST_METHOD))
				+ " "
				+ String.valueOf("Request URI:" + inboundMessage.get(Message.REQUEST_URI))
				+ String.valueOf(" Header Info:" + inboundMessage.get(Message.PROTOCOL_HEADERS))
				+ "; Response: "
				+ Integer.parseInt(String.valueOf(outboundMessage.get(Message.RESPONSE_CODE)))
				+ (error != null ? "; Error: " + error : ""));
		}
		
		if( error == null ) {
			//SUCCESS
			//Probably a combination of pattern and method to record AAL events 
			if( String.valueOf(inboundMessage.get(Message.REQUEST_URI)).contains("/session") && 
					String.valueOf(inboundMessage.get(Message.HTTP_REQUEST_METHOD)).equals("GET") ) {
				/* TODO: uncheck the patient
				if(CacheHandler.getInstance().getSession().getPatient() != null) {
//				Auditor.auditLoginFromMHVAPI(((Patient)CacheHandler.getInstance().getSession().getPatient()).getUserProfile().getId(), 
//													true, CacheHandler.getInstance().getSession().getClientApplication().getName());
//					log.info("Header Info: " + outboundMessage.get(Message.PROTOCOL_HEADERS));	
				}
				*/
				
			}
		}
		CacheHandler.resetInstance();
	}

	public void handleFault(Message outboundMessage) {
		CacheHandler.resetInstance();
		//Nothing to do here
	}
	
}
